'use strict';

function ResultsUsersCtrl($scope, $rootScope, UserLogManager, $http, AppConfig){
    $scope.users = UserLogManager.loadData();

    $scope.sortField = 'username';
    $scope.sortReverse = false;

    $scope.search = '';


    $scope.isSortFieldSelected = function(fieldName, reversed){
        return fieldName == $scope.sortField && $scope.sortReverse == reversed;
    }

    $scope.changeSort = function(fieldName){
        $scope.sortReverse = ($scope.sortField == fieldName) ? !$scope.sortReverse : false;
        $scope.sortField = fieldName;
    }

    $scope.exportActivityN3 = function() {
        var message = {
            title: 'Generowanie pliku'
            ,msg: 'Proszę czekać'
            ,type: 'loading'
        }
        $rootScope.$broadcast('Message:addMsg', message);
        $http.post(AppConfig.urlUserActivityN3, {n3data: $scope.users})
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                if(data == 'OK') {$rootScope.getSessionFile();}
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
            })
        ;

    }

    $scope.exportNotesN3 = function(user) {
        var message = {
            title: 'Generowanie pliku'
            ,msg: 'Proszę czekać'
            ,type: 'loading'
        }
        $rootScope.$broadcast('Message:addMsg', message);
        $http.post(AppConfig.urlUserNotesN3, {n3data: user.id})
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                if(data == 'OK') {$rootScope.getSessionFile();}
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
            })
        ;

    }

}

ResultsUsersCtrl.$inject = ['$scope', '$rootScope', 'UserLogManager', '$http', 'AppConfig'];